 ; Ŀ
 ;   ZLIN - Line pattern drawer.                                           
 ;   Copyright 1993, 2000 by Rocket Software                               
 ;   Rocket: software you wish you needed to use.                          
 ; 

 ; Ŀ
 ;   Abalone - the error handler.                                          
 ; 
 (DEFUN ABALONE (shk)
  (setq *error* prev)
  (setvar "blipmode" blip)
  (if (/= shk "Function cancelled")
      (write-line shk))
 (princ))
 ; Ŀ
 ;   Abalone end.                                                          
 ; 

 ; Ŀ
 ;   Subroutine Sidewinder - draw the pattern.                             
 ; 
 (DEFUN SIDEWINDER (/ num pa paa ang len patang patdis ppa ovang ovlen angdif
                                            prev numm remlen lensp noscale pb)
 ; Ŀ
 ;   Find slope and distance between start and end of pattern.             
 ; 
  (setq num 0)
  (setq pa (setq paa (list 0 0)))
  (while (setq ang (nth num angs))             ; while there are segments
         (setq len (nth num lens))
         (setq pa (polar pa ang len))          ; next endpoint dist/angle
         (setq num (1+ num)))
  (setq patang (angle paa pa))                 ; overall pattern angle
  (setq patdis (distance paa pa))              ; overall pattern length
 ; Ŀ
 ;   Get start and end points.                                             
 ; 
  (if psav 
     (progn
          (setq ppa (getpoint psav
                             "\nStart point or <Return> to use base point: "))
          (if ppa
             (setq pa ppa)                           ; new point or
             (setq pa psav)))                        ; use start point
     (setq pa (getpoint "\nStart point: ")))
  (setq ppa (getpoint pa "And end point: ")) ; and end
 ; Ŀ
 ;   And the distance and angle between them.                              
 ; 
  (setq ovang (angle pa ppa))
  (setq ovlen (distance pa ppa))
 ; Ŀ
 ;   Now calculate the difference in angles between the pattern and the    
 ;   start and end points and save it to be added to each line segment.    
 ; 
  (setq angdif (- patang ovang))
 ; Ŀ
 ;   Find out how to proceed - number of repeats, scale, unscaled...       
 ; 
  (if lenscl (setq prev (strcat "/Previous scale (" (rtos lenscl 2 2)")"))
             (setq prev ""))
  (setq numm (getstring (strcat "\nNumber of patterns/Scale" prev
                                "/<Maximum unscaled>: ")))
 ; Ŀ
 ;   If numm exists then use numm repeats and scale the lines.  If not     
 ;   then setq num = the number that will fit, rem/2 = line length start   
 ;   and end, don't scale the lines.                                       
 ; 
  (setvar "blipmode" 0)
  (command "pline" pa)                                  ; start pline command
 ; Ŀ
 ;   Cond: a number of repeats was input.                                  
 ; 
  (cond ((= (type (read numm)) 'INT)                ; numm is an integer
         (setq numm (read numm))                    ; so convert it
         (if (= numm 0) (setq numm 1))              ; make sure it isn't zero
         (setq lenscl (/ (/ ovlen numm) patdis)))   ; get the length scale
 ; Ŀ
 ;   Cond: The letter N was input instead of a number.                     
 ; 
        ((= (strcase (substr numm 1 1)) "N")
         (setq numm (getint "Number of patterns: "))
         (if (= numm 0) (setq numm 1))              ; make sure numm isn't zero
         (setq lenscl (/ (/ ovlen numm) patdis)))
 ; Ŀ
 ;   Cond: use previous scale (wasn't prompted for if lenscl var wasn't    
 ;   set, but might be called anyway.  Use 1 if called and (null lenscl)). 
 ; 
        ((= (strcase (substr numm 1 1)) "P")                 ; use prev scale
         (if (null lenscl) (setq lenscl 1))                  ; safety
         (setq numm (fix (/ ovlen (* patdis lenscl))))       ; total repeats
         (setq remlen (/ (rem ovlen (* patdis lenscl)) 2.0)) ; rem. length
         (command (setq pa (polar pa ovang remlen))))        ; draw rem. line
 ; Ŀ
 ;   Cond: the user would like to input a scale.                           
 ; 
        ((= (strcase (substr numm 1 1)) "S")
         (if (null lenscl) (setq lenscl 1))
         (setq lensp (getreal (strcat "Scale factor <"
                                      (rtos lenscl 2 2) ">: ")))
         (if lensp (setq lenscl lensp))
         (setq numm (fix (/ ovlen (* patdis lenscl))))       ; total repeats
         (setq remlen (/ (rem ovlen (* patdis lenscl)) 2.0)) ; rem. length
         (command (setq pa (polar pa ovang remlen))))        ; draw rem. line
 ; Ŀ
 ;   Default condition: fit in as many unscaled patterns as will fit.      
 ;   Originally:  (or (= (strcase (substr numm 1 1)) "M")                  
 ;                    (= numm ""))                                         
 ;   but now just T in case anything unforseen is entered.                 
 ; 
        (T
         (setq numm ())
         (setq noscale T)                              ; flag - don't scale
         (setq numm (fix (/ ovlen patdis)))            ; number of repeats
         (setq remlen (/ (rem ovlen patdis) 2.0))      ; remainder line length
         (command (setq pa (polar pa ovang remlen)))   ; draw remainder line
        )); cond end
 ; Ŀ
 ;   Now draw the lines.                                                   
 ; 
  (repeat numm
         (setq num 0)                            ; start of pattern
         (while (setq ang (nth num angs))        ; next angle
                (setq len (nth num lens))        ; next length
                (if (null noscale)               ; if scaled pattern
                    (setq len (* len lenscl)))   ; then scale length
                (setq ang (- ang angdif))        ; match angle to overall ang
                (setq pb (polar pa ang len))     ; next vertex position
                (command pb)                     ; draw it
                (setq pa pb)                     ; last point becomes base
                (setq num (1+ num))))            ; next pos in both lists
 ; Ŀ
 ;   And draw the remainder line if the patterns weren't scaled to fit.    
 ; 
  (if remlen
     (command (setq pa (polar pa ovang remlen)) "")
     (command ""))
 ; Ŀ
 ;   Save the last point as the new default start, return.                 
 ; 
  (setq psav pa)
 (princ))
 ; Ŀ
 ;   Sidewinder end.                                                       
 ; 

 ; Ŀ
 ;   Subroutine Gecko - get a new pattern.                                 
 ; 
 (DEFUN GECKO (/ nxpt nxangl nxlen)
  (setq angs ())                                     ; empty angle list
  (setq lens ())                                     ; empty length list
  (setvar "blipmode" 1)
  (setq pa (getpoint "Base point: "))
  (while (setq nxpt (getpoint pa "Next point: "))
         (setq nxangl (angle pa nxpt))
         (setq angs (append angs (list nxangl)))
         (setq nxlen (distance pa nxpt))
         (setq lens (append lens (list nxlen)))
         (grdraw pa nxpt -1 1)
         (setq pa nxpt))
 (princ))
 ; Ŀ
 ;   Gecko end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Crab - save the current pattern to a file.                 
 ; 
 (DEFUN Crab (/ filnam quipt subfil pos nexang nexlng)
  (setq filnam (getstring "\nFilename: "))
  (if (findfile filnam)
      (progn
           (initget 0 "Overwrite Quit")
           (setq quipt (getkword (strcat "That file already exists."
                                         "  Overwrite or <Quit>? ")))
           (if (null quipt) (setq quipt "Quit"))))
  (cond ((= quipt "Quit")                            ; file exists - quit
         (setq subfil ()))
        ((= quipt "Overwrite")                       ; file exists - overwrite
         (setq subfil (open filnam "w"))
         (if (null subfil)
         (write-line "Unable to open that file.")))
        (T                                           ; file doesn't exist
         (setq subfil (open filnam "w"))
         (if (null subfil)
         (write-line "Unable to open that file."))))
 ; Ŀ
 ;   Now probably have a file handle open for writing.  If so:             
 ; 
  (if subfil
      (progn
 ; Ŀ
 ;   Write the angle and length lists to the file.                         
 ; 
   (write-line " Ŀ" subfil)
   (write-line "   Zlin.lsp pattern file.                           " subfil)
   (write-line "   The format is  Angle (degrees)                   " subfil)
   (write-line "                  Length (drawing units)            " subfil)
   (write-line "                  Optional empty line               " subfil)
   (write-line "   Comments can be placed anywhere so long as each  " subfil)
   (write-line "   is on its own line.                              " subfil)
   (write-line " " subfil)
           (setq pos 0)
           (while (setq nexang (nth pos angs))
                  (setq nexang (* 180 (/ nexang pi)))
                  (print nexang subfil)
                  (setq nexlng (nth pos lens))
                  (print nexlng subfil)
                  (write-line "" subfil)
                  (setq pos (1+ pos)))
           (close subfil)))
 (princ))
 ; Ŀ
 ;   Crab end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Barnacle - read a pattern from a file.                     
 ; 
 (DEFUN BARNACLE (/ filnam aaa typ subfil which linn)
  (setq filnam (getstring "\nFilename: "))
  (if (and (setq aaa (findfile filnam))
           (setq subfil (open aaa "r")))
      (progn
           (setq angs ())                                ; empty angle list
           (setq lens ())                                ; empty length list
           (setq which "ang")
           (while (setq linn (read-line subfil))
                  (setq typ (type (setq linn (read linn))))
 ; Ŀ
 ;   Make sure that only numbers are added to the Angle and length lists.  
 ;   Under WinNT the box drawing characters are Read as their ascii        
 ;   number.  Sometimes.                                                   
 ; 
                  (if (and (or (= typ 'REAL) (= typ 'INT))
                           (not (or (= linn 131) (= linn (chr 218)))))
                      (if (= which "ang")
                          (progn
                               (setq linn (/ (* linn pi) 180))
                               (setq angs (append angs (list linn)))
                               (setq which "len"))
                          (progn
                               (setq lens (append lens (list linn)))
                               (setq which "ang")))))
           (close subfil))
      (write-line "Unable to open that file."))
 (princ))
 ; Ŀ
 ;   Barnacle end.                                                         
 ; 

 ; Ŀ
 ;   Zlin - the skywriter.                                                 
 ; 
 (DEFUN C:ZLIN (/ blip patok sss)
  (setvar "cmdecho" 0)
  (setq prev *error*)
  (setq *error* abalone)
  (setq blip (getvar "blipmode"))
 ; Ŀ
 ;   Decide which options are available, ask what to do.                   
 ; 
  (if (and angs lens)
      (progn
           (initget 0 "Draw Save Read New")
           (setq patok "Save pattern/Read pattern/New pattern/<Draw line>: ")
           (setq sss (getkword patok))
           (if (null sss) (setq sss "Draw")))
      (progn
           (initget 0 "Read New")
           (setq patok "Read pattern/<New pattern>: ")
           (setq sss (getkword patok))
           (if (null sss) (setq sss "New"))))
 ; Ŀ
 ;   Now do whatever was ordered.                                          
 ; 
  (cond ((= sss "Save") (Crab))
        ((= sss "Read")
         (Barnacle)
         (if (and angs lens aaa) (Sidewinder)))
        ((= sss "New") (Gecko) (Sidewinder))
        ((= sss "Draw") (Sidewinder)))
  (setq *error* prev)
 (princ))